#define BRIDGE2

#define ANIMATION 1
#define LIGHTING 1
#define STEREO 0
#define GAMMA 1
#define HAS_SHADOWS 1
#define SOFT_SHADOWS 1
#define HAS_AO 1
#define HAS_SPECULAR 0


#define MAX_NODES_COUNT 9
#include "shaders\resources.hlsl"
#include "shaders\sd.hlsl"
#include "shaders\ibox.hlsl"
// Optimization params
#define USE_BB_OPTIMIZATION       0
#define USE_FULL_MAP_FOR_SHADOWS  1
#define USE_BB_DEBUG              0
// Global params
#define SHOW_ITERATIONS_COUNT     0
#define DISCARD_BACKGROUND        1
#define MAX_RAY_DISTANCE        500
#define MAX_RAY_STEPS           250
                         
// Shadows params
#define USE_ADAPTIVE_SHADOWS      0
// FIXME: should depend on minimal geometry thickness (otherwise seams in shadows)
#define SHADOWS_TMIN           0.02
#define SHADOWS_TMAX           25.0
#define SOFT_SHADOWS_MAXSTEPS   100
#define SOFT_SHADOW_EXPONENT    40.0

#define RAYCASTING_PRECISION    0.0001
#define NORMAL_EPS              0.005

#define SUN_EXPONENT            128.0
#define SUN_GLOW_EXPONENT       8.0

// TODO: use preprocessor for this
// Btw speed fps is increasing when setting those to false, so it's ok, i guess
static const bool hasShadows   = HAS_SHADOWS;
static const bool softShadows  = SOFT_SHADOWS;
static const bool hasAO        = HAS_AO;
static const bool hasSpecular  = HAS_SPECULAR;
// Lighting params
#define USE_DYNAMIC_LIGHTING      0
//static const float3 iLightPosition = float3(0.3, 0.5, 1.2);
static const float3 iLightPosition = -lightDir.xyz;
//static const float3 iLightPosition = float3(0.0, 0.4, 0.5);

// Some other params
#if ANIMATION
static const float  iGlobalTime = params.x * 0.5;
#else
static const float  iGlobalTime = 0.0;
#endif
static const float  gammaExponent = 1.0 / 2.2;

// Scene nodes count
#ifdef BRIDGE2
  #define NODE_COUNT  9
#endif
#ifdef COLUMNS
  #define NODE_COUNT  2
#endif
#ifdef CONSTANT_WIDTH
  #define NODE_COUNT  8
#endif
#ifdef OPTI
  #define NODE_COUNT  6  
#endif
#ifdef SMOKE
  #define NODE_COUNT  1
#endif

// Array of visibility flags for scene nodes
static bool  gVisible[NODE_COUNT];
// Current single visible node
static float gNearestNode;

#ifdef BRIDGE2
  #include "shaders\scenes\bridge2.hlsl"
#endif
#ifdef COLUMNS
  #include "shaders\scenes\columns.hlsl"
#endif
#ifdef CONSTANT_WIDTH
  #include "shaders\scenes\constant_width.hlsl"
#endif 
#ifdef OPTI
  #include "shaders\scenes\opti.hlsl"
#endif
#ifdef SMOKE
  #include "shaders\scenes\smoke.hlsl"
#endif

struct VS_INPUT
{
	float4 Pos : POSITION;
	float2 UV : TEXCOORD0;
};

struct VS_OUTPUT
{
  float4 Pos : SV_POSITION;
  float2 UV : TEXCOORD0;
};

#include "shaders\common.hlsl"
#include "shaders\marching.hlsl"

VS_OUTPUT VS(in VS_INPUT input/*in uint vertexID : SV_VertexID*/)
{
  VS_OUTPUT output = (VS_OUTPUT)0;

  //output.UV = float2((vertexID << 1) & 2, vertexID & 2);
  //output.Pos = float4(float2(2.f, -2.0f) * output.UV + float2(-1.f, 1.0f), 0.2f, 1.0f);
  output.UV = input.UV;
  output.Pos = input.Pos;

  return output;
}


#if 0
#ifdef CSG
float2 map(in float3 pos)
{
  float3 sizeBox = float3(1.0, 1.0, 1.0);
  float4 sizeSphere = float4(0.0, 0.0, 0.0, 1.35);
  float3 sizeCutBox1 = float3(0.1, 2.0, 2.0);
  //float4x4 rot = rotationAxisAngle(float3(0.0, 1.0, 0.0), PI / 2.0);
  //float3 sizeCutBox1 = mul(float4(sizeCutBox, 0.0), rot).xyz;
  float3 sizeCutBox2 = sizeCutBox1.yxz;
  float3 sizeCutBox3 = sizeCutBox1.yzx;

  float3 sizeCrsBox1 = float3(0.15, 0.15, 0.6);
  float3 sizeCrsBox2 = sizeCrsBox1.xzy;
  float3 sizeCrsBox3 = sizeCrsBox1.zxy;

  float2 dis = opS(opS(opS(opS(sdBox(pos, sizeBox), sdSphere(pos, sizeSphere)),
                           sdBox(pos, sizeCutBox1)),
                       sdBox(pos, sizeCutBox2)),
                   sdBox(pos, sizeCutBox3));

  float2 cross = opU(opU(sdBox(pos, sizeCrsBox1), sdBox(pos, sizeCrsBox2)), sdBox(pos, sizeCrsBox3));
  cross.y = 3.0;

  dis = opU(dis, cross);

  //dis = opU(dis, sdPlane(pos + float3(0.0, 1.3, 0.0)));

  return dis;
}
#endif // CSG

#ifdef TEST
float2 map(in float3 pos)
{
  return /*opU(*/opU(sdSphere(pos - float3(0.4, 0.8, 0.0), 0.25), opS(sdBox(pos - float3(0.15, 0, 0.15), float3(0.15, 0.55, 0.15)),
                                                                  sdSphere(pos, 0.25)));//,
                /*sdPlane(pos + float3(0.0, 0.6, 0.0)));*/
  //return sdBox(pos - float3(5.0, 1.65, -5.0), float3(2.15, 1.55, 2.15));
}
#endif // TEST

#endif // 0

#ifdef SMOKE
float3 render(in float3 ro, in float3 rd, out float3 wpos, /*out float3 wrefl, */out float _ao)
{
  float4 sum = (float4)0;

	float t = 0.0;

    // dithering	
	//t += 0.05*texture2D( iChannel0, gl_FragCoord.xy/iChannelResolution[0].x ).x;
	wpos = (float3)0;
  _ao = 0.0;
	for( int i=0; i<100; i++ )
	{
		if( sum.y > 0.99 ) continue;
		
		float3 pos = ro + t*rd;
    wpos = pos;
		float2 dens = map( pos );
		float3 col = shade(dens.x);
		col.xyz *= lerp( 3.1*float3(1.0,0.5,0.05), float3(0.48,0.53,0.5), saturate((pos.y-0.2)/2.0) );
		
		dens.x *= 0.6;
		col.rgb *= dens.x;

		sum.xyz = sum.xyz + col * (1.0 - sum.a);	
    sum.a = sum.a + dens.x * (1.0 - sum.a);
    
		t += 0.05;
	}

	return saturate(sum.xyz);
}
#else
float3 render(in float3 ro, in float3 rd, out float3 wpos, /*out float3 wrefl, */out float _ao)
{
  // Directional light source
  float3 lig = normalize(iLightPosition);
#if USE_DYNAMIC_LIGHTING
  lig = rotateVector(makeQuat(x, iGlobalTime), lig);
#endif // USE_DYNAMIC_LIGHTING

  float3 col = 2.5*float3(0.18,0.33,0.45) - rd.y*1.5;
  col *= 0.9;
  float sun = saturate(dot(rd,lig));
  col += float3(2.0,1.5,0.0)*0.8*pow(sun, SUN_EXPONENT);

  float3 bgcol = col;

  float2 cuv = ro.xz + rd.xz*(100.0-ro.y)/rd.y;
  float cc = TEXTURES[0].Sample(SAMPLERS[1], 0.0003*cuv +0.1+ 0.013*iGlobalTime).x;
  cc = 0.65*cc + 0.35*TEXTURES[0].Sample(SAMPLERS[1], 0.0003*2.0*cuv + 0.013*.5*iGlobalTime).x;
  cc = smoothstep(0.3, 1.0, cc);
  col = lerp(col, float3(1.0,1.0,1.0)*(0.95+0.20*(1.0-cc)*sun), 0.7*cc);

  // Cast ray and get intersection distance + object/material index
  float3 bbcolor = float3(0, 0, 0);

#if USE_BB_OPTIMIZATION
  float nearestNode = -1;
  float minDistance = INF;
  for (float i = 0; i < NODE_COUNT; i += 1.0f)
  {
    float isect = iBox(ro, rd, i);

    if (isect > 0.0 /*!= -1*/)
    {
      gVisible[i] = true;
      bbcolor += gColors[i];
    //  bbcolor = gColors[i];
    //  wpos = ro + rd * isect;
    //  _ao = 1.0;
    //  return bbcolor;
    }
    //if (nearestNode >= 0)
    //  continue;
    if (isect > 0 /*!= -1*/ && isect < minDistance)
    {
      nearestNode = i;
      minDistance = isect;
      //break;
    }
  }
  // Set nearest node
  gNearestNode = nearestNode;
  // Clip background pixels
#ifndef BRIDGE2
  clip(nearestNode);
#else
  if (nearestNode < 0.0)
  {
    // sun glow
    col += float3(1.0,0.6,0.2)*0.4*pow(sun, SUN_GLOW_EXPONENT);
    return col;
  }
#endif // BRIDGE2

  float3 t = castRay(ro, rd, MAX_RAY_DISTANCE, minDistance - 0.1);
#else  
  float3 t = castRay(ro, rd, MAX_RAY_DISTANCE, 0.0);
#endif // USE_BB_OPTIMIZATION
  
  // Background
  float back = step(0.0, t.y);
  // Discard all background pixels (gives more fps!)
#if DISCARD_BACKGROUND && !USE_BB_DEBUG
#ifndef BRIDGE2
  clip(t.y + 0.001);
#else
  if (t.y < 0.0)
  {
    // sun glow
    col += float3(1.0,0.6,0.2)*0.4*pow(sun, SUN_GLOW_EXPONENT);
    return col;
  }
#endif // BRIDGE2
#endif // DISCARD_BACKGROUND && !USE_BB_DEBUG

#if USE_BB_OPTIMIZATION && USE_BB_DEBUG
  if (t.y < 0)
  {
    return float3(bbcolor*0.1);
  }
#endif

  // Intersection position
  float3 pos = ro + rd * t.x;
  wpos = pos;
  wpos.z = lerp(1.0f, wpos.z, back);
  // Calculate sufrace normal
  float3 norm = calcNormal(pos);
  // Calculate ambient occlusion
  float ao = hasAO * calcAO(pos, norm) + (1 - hasAO);
  _ao = ao;
  // Dot product
  float diff = saturate(dot(lig, norm));
  // Shadow
  float sh = 1.0;
  if (softShadows)
  {
#if USE_ADAPTIVE_SHADOWS
    sh = lerp(sh, softShadowAdaptive(pos, lig, SHADOWS_TMIN, SHADOWS_TMAX, SOFT_SHADOW_EXPONENT, t.x), hasShadows);
#else                                           
    sh = lerp(sh, softShadow(pos, lig, SHADOWS_TMIN, SHADOWS_TMAX, SOFT_SHADOW_EXPONENT), hasShadows);
#endif // USE_ADAPTIVE_SHADOWS
  }
  else
  {
    sh = lerp(sh, shadow(pos, lig, SHADOWS_TMIN, SHADOWS_TMAX), hasShadows);
  }
  float3 wrefl = reflect(rd, norm);
  // Specular exponent
  float spec = saturate(dot(lig, wrefl));
  // Diffuse component
  float3 diffuse = diff * sh * ao;
  // Objects material color
  //float3 color = lerp(float3(0, 0.5, 0), float3(1, 0.5, 0), t.y);
  float3 color = shade(pos, norm, rd, t.y);
  // Specular component
  float3 specular = hasSpecular * pow(spec, 1024) * sh;
  // Ambient component
  float3 ambient = 0.70 * float3(0.10, 0.11, 0.13);
  // Fresnel
  //float fre = ao * pow(saturate(1.0 + dot(norm, rd)), 5.0) * 0.75;
  float fre = 0.0;

#ifdef BRIDGE2
  // Make road strips glow
  color += abs(sin(iGlobalTime)) * float3(1.0, 0.3, 0.0) / (centerStrips(pos - norm*.01) * 20.0 + 0.75) * 3.0;
#endif // BRIDGE2

  // Final color
#if LIGHTING
  //float3 res = saturate(col);
#if USE_BB_DEBUG
  float3 res = saturate((diffuse + ambient) * color + specular + fre + bbcolor * 0.1) * back;
#else
  float3 res = saturate((diffuse + ambient) * color + specular + fre) * back;
#endif

#ifdef BRIDGE2
  // sun glow
  res += float3(1.0,0.6,0.2)*0.4*pow(sun, SUN_GLOW_EXPONENT);
#endif // BRIDGE2

#elif HAS_AO && HAS_SHADOWS
  float3 res = float3(ao, ao, ao) * sh;
#elif !HAS_AO && HAS_SHADOWS
  float3 res = float3(sh, sh, sh);
#elif !HAS_SHADOWS
  float3 res = float3(ao, ao, ao);
#else
  float3 res = float3(0.0, 0.0, 0.0);
#endif

  //float3 res = saturate((1.0 + ambient) * color + specular + fre) * back;
  //res *= exp(0.0625 * 0.25 * -t.x * t.x);

  //return float3(t.x / MAX_RAY_DISTANCE, t.x / MAX_RAY_DISTANCE, t.x / MAX_RAY_DISTANCE);

  //return abs(norm);

#if SHOW_ITERATIONS_COUNT
  //float steps = saturate(log10(t.z + 10) / 10.0);
  float steps = t.z / 150;
  return float3(steps, steps, steps);
#else
  return res;
#endif
}

#endif

//float4 PS(in VS_OUTPUT input, out float depth : SV_Depth) : SV_Target
float4 PS(in VS_OUTPUT input/*, out float depth : SV_DepthLessEqual*/) : SV_Target
{
  float2 p = input.UV;
  //return float4(p, 1.0, 1.0);
  p = 2 * p - 1;

	// the  gallerymodel is a factor 1./0.7 too high to match Eschers painting, so I cheat :(
	//p.x *= 0.7;
	//p = escherDeformation(p);	
	//p = drosteTransformation(p);

  //float tex = TEXTURES[0].Sample(SAMPLERS[1], input.UV).y;
  //return float4(tex, tex, tex, 1.0);

  //return float4(abs(iLightPosition), 1.0);
#if ESCHER_DEBUG
  //return float4(abs(p), 0.0, 1.0);
#endif

#if STEREO
  float2 gl_FragCoord = input.Pos;
	float eyeID = mod(gl_FragCoord.x + mod(gl_FragCoord.y, 2.0), 2.0);
  //return float4(eyeID, eyeID, eyeID, 1.0);
#endif // STEREO

  // Simple clipping (to check possible benefits from stencil test)
  //clip(-((p.y > 0.6) || (p.y <= -0.6)));

//  float fov = 3.1415925356 * 0.25f;
//  float tfov = tan(fov * 0.5f);
//  p.x *= (WndParams.x / WndParams.y);
//  p.xy *= tfov;
  p.xy *= camParams.xy;
  // cam
  float3 ro = camPos.xyz;//float3(-0.5, 1, 0.5);
  float3 ta = camTarget.xyz;//float3(0.0, 0.0, 0.0);
  //
  float3 cw = normalize( ta-ro );
	float3 cp = float3( 0.0, 1.0, 0.0 );
  // DX left-handed coordinate system
	float3 cu = normalize(cross(cp, cw));
	float3 cv = normalize(cross(cu, cw));
	float3 rd = normalize(p.x * cu + p.y * cv + cw);
  float3 newPos, newDir;
  float ao;

#if STEREO
	float3 fo = ro + rd * 100.0; // put focus plane behind scene
	ro -= 0.5 * cu * eyeID;      // eye separation
	rd = normalize(fo - ro);
#endif

  float3 res = render(ro, rd, newPos, /*newDir, */ao);

  float3 curPos = newPos;
  float3 origPos = curPos;
  //float3 curDir = newDir;
  //const uint REFL_DEPTH = 0;
  //for (uint i = 0; i < REFL_DEPTH; ++i) {
  //  float3 cur = render(curPos, curDir, newPos, newDir, ao);
  //  
  //  cur *= ao;
  //  res += cur;
  //  curPos = newPos;
  //  curDir = newDir;
  //}
  // Post - proj Z
  float4 viewSpacePos = mul(float4(origPos.xyz, 1.0f), (viewM));
  //depth = camParams.z + camParams.w / (viewSpacePos.z);

  // gamma
#if GAMMA
  //return float4(pow(res, 1.0 / 2.2), 1);
  float3 finalColor = pow(res, gammaExponent);
  //float3 finalColor = sqrt(res);
#else
  float3 finalColor = res;
#endif

#if STEREO
  finalColor *= float3(eyeID, 1.0 - eyeID, 1.0 - eyeID);
#endif

  return float4(finalColor, 1.0);
}